import gym
import numpy as np

from highway_env.road.lane import CircularLane
from highway_env.vehicle.kinematics import Vehicle


# %matplotlib qt

def distance_to_current_road_end(car: Vehicle) -> float:
    return np.linalg.norm(ego_car.position - ego_car.lane.end)


def distance_reward(car: Vehicle, multiplier: float = 1) -> float:
    return multiplier * (1 - (distance_to_current_road_end(car) / car.lane.length))


env = gym.make("roundabout-v0")
env.configure({
    "screen_width": 1280,
    "screen_height": 1000,
    "simulation_frequency": 15,
    "policy_frequency": 15
})
env.reset()
done = False

# Set initial destination for the ego_car
destination = env.road.network.get_random_destination()

print(env.observation_space, env.action_space)
print('destination:', destination)
ego_car = env.controlled_vehicles[0]

print('speed', ego_car.speed, ego_car.position)
print('lane (index)', ego_car.lane, ego_car.lane_index)

# ego_car.plan_route_to(destination)
i = 0
action1 = 0
while not done and i < 700:
    if i % 3 == 0:
        action1 = int(input("Action1: "))
    road_network = env.road.network
    if action1 == 0:
        move = [0, 0.2]
    elif action1 == 1:
        move = [0, -0.2]
    else:
        move = [0, 0]
        # action = [-1, 0]  # acceleration, steering
    obs_space, rew, term, trunc, info = env.step(1)
    # print(obs_space, rew, info)
    print("lane", ego_car.lane, ego_car.position)
    print(ego_car.lane.distance(ego_car.position), ego_car.lane.heading_at(ego_car.position))
    if isinstance(ego_car.lane, CircularLane):
        print(ego_car.lane.tangent_vector(ego_car.position))
    ## car

    # while distance to waypoint > threshold
    #
    # print(ego_car.speed, ego_car.position)
    # print(distance_to_current_road_end(ego_car), distance_reward(ego_car, 1))
    env.render()
    i += 1
